class rsyslog( $server='UNSET' , $port='UNSET' ){
	package {
		"rsyslog":
			ensure => "latest";
	}
	service{
		"rsyslog":
			enable => "true",
			ensure => "running";
	}
	if $server {
		file{
			"/etc/rsyslog.d/forward.conf":
				owner   => "root", 
				group   => "root",
				content => "*.*@@vm1:\$port";
		}
	}
	if $port {
		file{
			"/etc/rsyslog.d/tcp.conf":
				owner   => "root",
				group   => "root",
				content => "\$ModLoad imtcp\n\$InputTCPServerRun \$port\n";
		}
	}	
	
}
